//=============================================================================
// File: gnutbinarymsgbc.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutbinarymsgbc.h"
#include <cstring>
#include "gnut_types.h"
#include "gnut_util.h"
#include "gnutmsgparser.h"

//=============================================================================
GnutBinaryMsgBC::
GnutBinaryMsgBC(NodeAddr_t aInitialSender, 
                DescriptorID_t aId, GnutMsgParser::EGnutMsgType aType, 
                Byte_t aTtl, Byte_t aHops, const GnutCoord& aCoord,
                double aError)
: hdr_(aInitialSender, aId, aType, aTtl, aHops),
  coord_(aCoord),
  error_(aError),
  timeSent_(GnutUtil::now())
{ }
//=============================================================================
GnutBinaryMsgBC::
GnutBinaryMsgBC(const void* aMem)
{ 
    const char* ptr = reinterpret_cast<const char*>(aMem);

    memcpy(&hdr_, ptr, sizeof(hdr_));
    ptr += sizeof(hdr_);

    // Sanity check that enables us to use a little shortcut.
    static bool checked = false;
    if (checked == false)
    {
        GNUT_ASSERT(sizeof(double) == sizeof(coord_.mX));
        checked = true;
    }

    const double* dblptr = reinterpret_cast<const double*>(ptr);

    const double x = *dblptr;
    dblptr++;

    const double y = *dblptr;
    dblptr++;
    
    const double height = *dblptr;
    dblptr++;

    coord_ = GnutCoord(x, y, height);

    error_ = *dblptr;
    dblptr++;
    
    timeSent_ = *dblptr;
}
//=============================================================================
GnutBinaryMsgBC::
~GnutBinaryMsgBC(void)
{ }
//=============================================================================
void 
GnutBinaryMsgBC::
writeToPacket(void* aMem) const
{ 
    char* ptr = reinterpret_cast<char*>(aMem);

    memcpy(ptr, &hdr_, sizeof(hdr_));
    ptr += sizeof(hdr_);

    memcpy(ptr, &coord_.mX, sizeof(coord_.mX));
    ptr += sizeof(coord_.mX);

    memcpy(ptr, &coord_.mY, sizeof(coord_.mY));
    ptr += sizeof(coord_.mY);

    memcpy(ptr, &coord_.mHeight, sizeof(coord_.mHeight));
    ptr += sizeof(coord_.mHeight);

    memcpy(ptr, &error_, sizeof(error_));
    ptr += sizeof(error_);

    memcpy(ptr, &timeSent_, sizeof(timeSent_));
}
//=============================================================================
size_t
GnutBinaryMsgBC::
getSize(void) const
{
    return sizeof(hdr_) + sizeof(coord_.mX) + sizeof(coord_.mY)
           + sizeof(coord_.mHeight) + sizeof(error_) + sizeof(timeSent_);
}
//=============================================================================

