//=============================================================================
// File: gnutbootstrapresmsg.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutbootstrapresmsg.h"
#include "gnutmsgparser.h"

//=============================================================================
GnutBootstrapResMsg::
GnutBootstrapResMsg(int aCnt, const NodeAddr_t* aServents, 
                    const GnutCoord& aCoord, double aError)
: GnutConnectMsgBC(GnutMsgParser::GNUT_BOOTSTRAP_RES, aCoord, aError),
  res_(aCnt, aServents)
{ }
//=============================================================================
GnutBootstrapResMsg::
GnutBootstrapResMsg(const void* aMem)
: GnutConnectMsgBC(aMem),
  res_(0, 0)
{ 
    const char* ptr = reinterpret_cast<const char*>(aMem);
    ptr += GnutConnectMsgBC::getSize();
    memcpy(&res_, ptr, sizeof(res_)); 
}
//=============================================================================
GnutBootstrapResMsg::
~GnutBootstrapResMsg(void)
{ }
//=============================================================================
void 
GnutBootstrapResMsg::
writeToPacket(void* aMem)
{ 
    GnutConnectMsgBC::writeToPacket(aMem);

    char* ptr = reinterpret_cast<char*>(aMem);
    ptr += GnutConnectMsgBC::getSize();
    memcpy(ptr, &res_, sizeof(res_));
}
//=============================================================================
size_t
GnutBootstrapResMsg::
getSize(void) const
{
    return GnutConnectMsgBC::getSize() + sizeof(res_);
}
//=============================================================================

