//=============================================================================
// File: gnuteventlistener.h
// Author: Andre Dufour
//
// Class type: template
// Description:
//=============================================================================

#ifndef __GNUTEVENTLISTENER_H__
#define __GNUTEVENTLISTENER_H__

template <class T> class GnutEventListener : public IGnutEventListener
{
private:
    // = TYPES

    typedef void(T::*CallbackFcn)(void);

public:
    // = FOUNDATION

    GnutEventListener(T& aInstance, const CallbackFcn aCallback)
    : mInstance(aInstance),
      mCallback(aCallback) 
    { }
    virtual ~GnutEventListener(void) { };


    // = ACTION

    virtual void notify(void) const { (mInstance.*mCallback)(); } 

private:
    // = DATA

    T&                                  mInstance;
    const CallbackFcn                   mCallback;


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutEventListener(const GnutEventListener&);

    GnutEventListener& operator=(const GnutEventListener&);

};
//=============================================================================
#endif /* __GNUTEVENTLISTENER_H__ */

