//=============================================================================
// File: gnuthierapp.cc
// Author: Andre Dufour
//=============================================================================

#include "gnuthierapp.h"
#include "gnut_types.h"
#include "gnut_util.h"
#include "leaf.h"
#include "ultrapeer.h"
#include "gnut_util.h"
#include "tclcl.h"
#include "gnutstats.h"

//=============================================================================
unsigned long GnutHierApp::mUltrapeerMinTime = 300; // TODO: AD test
const char* GnutHierApp::APP_NAMES[EGnutAppLast] = 
                       { "LeafActive", "UltrapeerActive", "LegacyActive" };
//=============================================================================
GnutHierApp::
GnutHierApp(NodeAddr_t aAddr, bool aUltrapeerCapable)
: mAddr(aAddr),
  mActiveApp(0),
  mUltrapeerCapable(aUltrapeerCapable),
  mRole(EGnutAppLast)
{
    GnutUtil::gnutTrace("Creating hier app that is %supeer capable for %d\n",
           aUltrapeerCapable ? "" : "not ", mAddr);
    // TODO: AD - wish there was a more elegant way to do this.
    mAppActiveAction[EGnutAppLeaf] = &GnutHierApp::leafActive;
    mAppActiveAction[EGnutAppUltrapeer] = &GnutHierApp::ultrapeerActive;
    mAppActiveAction[EGnutAppLegacy] = &GnutHierApp::legacyActive;
}
//=============================================================================
GnutHierApp::
~GnutHierApp(void)
{
    // TODO: AD perform other cleanup?
    GnutUtil::gnutTrace("GnutHierApp::dtor called\n");
    delete mActiveApp;
}
//=============================================================================
int
GnutHierApp::
command(int argc, const char*const* argv)
{ 
    if (strcmp(argv[1], "linkActiveApp") == 0)
    {
        if (argc == 4)
        {
            for (unsigned int iter = 0; iter < EGnutAppLast; iter++)
            {
                if (strcmp(argv[2], APP_NAMES[iter]) == 0)
                {
                    GnutStats::instance().setPeerState(mAddr, (EGnutApp)iter);
                    return (this->*mAppActiveAction[iter])(argv[3]);
                }
            }
        }
        return TCL_ERROR;
    }
    else if (strcmp(argv[1], "debug_status") == 0)
    {
        mActiveApp->debug_status();
    }

    GNUT_ASSERT(mActiveApp);
    mActiveApp->command(argc, argv);

    return TCL_OK;
}
//=============================================================================
// Static
void 
GnutHierApp::
setMinUltrapeerTime(unsigned long aSeconds)
{
    GnutHierApp::mUltrapeerMinTime = aSeconds;
}
//=============================================================================
int
GnutHierApp::
leafActive(const char* const aApp)
{
    GNUT_ASSERT(aApp != 0);

    // TODO: AD do appropriate cleanup
    delete mActiveApp; // TODO: AD do the delete? What about TCL side?
    

    mRole = EGnutAppLeaf;
    mActiveApp = reinterpret_cast<Leaf*>(TclObject::lookup(aApp));

    return TCL_OK;
}
//=============================================================================
int
GnutHierApp::
ultrapeerActive(const char* const aApp)
{
    GNUT_ASSERT(aApp != 0);

    GNUT_ASSERT(mUltrapeerCapable != false);

    // TODO: AD do appropriate cleanup
    delete mActiveApp; // TODO: AD do the delete? What about TCL side?
    mActiveApp = 0;

    mRole = EGnutAppUltrapeer;
    mActiveApp = reinterpret_cast<Ultrapeer*>(TclObject::lookup(aApp));
    return TCL_OK;
}
//=============================================================================
int
GnutHierApp::
legacyActive(const char* const aApp)
{
    GNUT_ASSERT(aApp != 0);

    // TODO: AD do appropriate cleanup
    delete mActiveApp; // TODO: AD do the delete? What about TCL side?
    mActiveApp = 0;

    mRole = EGnutAppLegacy;
    mActiveApp = reinterpret_cast<GnutellaApp*>(TclObject::lookup(aApp));
    return TCL_OK;
}
//=============================================================================
void 
GnutHierApp::
setActiveApp(EGnutApp aApp)
{
    GNUT_ASSERT(aApp == EGnutAppLegacy || 
                aApp == EGnutAppLeaf   ||
                aApp == EGnutAppUltrapeer);

    const char* const app = APP_NAMES[aApp];

    Tcl::instance().evalf("%s setActiveApplication %d %s",
                          name(), mAddr, app);

    GnutStats::instance().setPeerState(mAddr, aApp);
}
//=============================================================================
void 
GnutHierApp::
leafGuidance(NodeAddr_t aInitUpeer)
{
    GnutUtil::gnutTrace("Parent %d responding to leaf guidance from %d\n", 
           mAddr, aInitUpeer);

    delete mActiveApp; // also causes cleanup in TCL
    mActiveApp = 0;
    
    Tcl::instance().evalf("%s setActiveApplication %d LeafActive %d",
                          name(), mAddr, aInitUpeer);
}
//=============================================================================
static class GnutHierAppClass: public TclClass {
public:
  GnutHierAppClass(): TclClass("GnutHierApp") {}
  TclObject* create(int argc, const char*const* argv) {
    return (new GnutHierApp(atoi(argv[4]), (bool)atoi(argv[5])));
  }
}class_gnuthierapp;
//=============================================================================

