//=============================================================================
// File: gnuthierapp.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: Encapuslates the functionality of leafs and ultrapeers as well
//              as the rules governing leaf/ultrapeer promotions and demotions.
//              This is done to more closely approximate the dynamic behaviour 
//              of the hierarchical Gnutella 0.6 network.
//=============================================================================

#ifndef __GNUTHIERAPP_H__
#define __GNUTHIERAPP_H__

#include "gnut_types.h"
#include "ignutellaapp.h"

class GnutHierApp : public TclObject
{    

public:
    // = FOUNDATION

//    GnutHierApp(NodeAddr_t aAddr, EGnutAppType aInitAppType, bool aUltrapeerCapable);
    GnutHierApp(NodeAddr_t aAddr, bool aUltrapeerCapable);
    virtual ~GnutHierApp(void);

 
    // TODO: AD check
    int command(int argc, const char*const*);

    static void setMinUltrapeerTime(unsigned long aSeconds);


    // = ACCESS

    EGnutApp getRole(void) const { return mRole; }

    // = ACTION
public: 
    // Called by ultrapeers that wish to obey leaf guidance. The ultrapeer
    // will be destroyed and recreated as a leaf that attempts to connect to
    // aInitUpeer (the upeer that offered the leaf guidance).
    void leafGuidance(NodeAddr_t aInitUpeer);

private:
    int leafActive(const char* const aApp);
    int ultrapeerActive(const char* const aApp);
    int legacyActive(const char* const aApp);
    void setActiveApp(EGnutApp aApp);

protected:

    // = TYPES

    typedef int (GnutHierApp::*AppActiveAction)(const char* const aApp);
    // Action functions to be called when an the active application type changes.
    
 
    // = DATA

    NodeAddr_t              mAddr;
    IGnutellaApp*           mActiveApp;
    const bool              mUltrapeerCapable;
    EGnutApp                mRole;
    AppActiveAction         mAppActiveAction[EGnutAppLast];
    // Coupled with APP_NAMES. 
    // TODO: AD Find way to improve this.

    static unsigned long    mUltrapeerMinTime;
    // The minimum number of seconds a peer must be online before being
    // eligible for promotion to ultrapeer status.


    // = CONSTANTS

    static const char*      APP_NAMES[EGnutAppLast];


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutHierApp(const GnutHierApp&);
    GnutHierApp& operator=(const GnutHierApp&);
};
//=============================================================================
#endif /* __GNUTHIERAPP_H__ */

