//============================================================================
// File: gnutmsgparser.h
// Author: Andre Dufour
// 
// Class type: singleton
// Description: handles parsing of Gnutella protocol messages. Also
//              responsible for their creation and destruction.
//============================================================================

#ifndef __GNUTMSGPARSER_H__
#define __GNUTMSGPARSER_H__

#include "gnut_types.h"

class IGnutMsg;
class GnutDescHdr;
union GnutPayload;
class GnutCoord;

//============================================================================
/* Gnutella Message Handler */
class GnutMsgParser 
{
private:
    // = FOUNDATION

    GnutMsgParser(void);
    virtual ~GnutMsgParser(void); 

public:
    // = TYPES

    typedef enum 
    {
        // Order is important here as it implies priority.
        GNUT_BINARY_MSG_FIRST = 0,
        GNUT_QUERYHIT = GNUT_BINARY_MSG_FIRST,
        GNUT_QUERY,
        GNUT_PONG,
        GNUT_PING,
        GNUT_BOOTCACHE_UPDATE,

        GNUT_BINARY_MSG_LAST = GNUT_BOOTCACHE_UPDATE,
//        GNUT_PUSH,

        GNUT_BOOTSTRAP,
        GNUT_BOOTSTRAP_RES,
        GNUT_LEGACY_CONNECT,
        GNUT_OK,
        GNUT_REJ,
        GNUT_ULTRA_CONNECT,
        GNUT_LEAF_CONNECT,
        GNUT_ULTRA_OK,
        GNUT_LEAF_OK,
        GNUT_ULTRA_LEAF_DIR,

        GNUT_MSG_LAST
    } EGnutMsgType;


    // = ACCESS

    static GnutMsgParser& instance(void);

    static bool isBinaryMsg(EGnutMsgType aType) 
    { return aType >= GNUT_BINARY_MSG_FIRST && aType <= GNUT_BINARY_MSG_LAST; }



    // = ACTION

    // "header" will be filled out. 
    virtual EGnutMsgType parse(const unsigned char* data, 
                               GnutDescHdr* header,
                               GnutPayload* payload,
                               GnutCoord* coord,
                               double* error,
                               double* timeSent) const;

    // Build packet from message.
    PacketData* newpacket(const IGnutMsg& aMsg) const;

    // Generate new GUID
    double getNewGuid(void);

private:
    // = DATA

    double          mGuid;


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutMsgParser(const GnutMsgParser&);
    GnutMsgParser& operator=(const GnutMsgParser&);
};
//============================================================================
// Structures to represent Gnutella msgs
//struct tQuery
//{
//    Word_t minSpeed_;
//    char *criteria_;
//};
//============================================================================
//struct tQueryHit
//{
//    Byte_t num_hits_;
//    Word_t port_;
//    NodeAddr_t addr_;
//    int speed_;
//};
//============================================================================
//struct tPush
//{
//  ServentID_t srvid_;
//  int idx_;
//  NodeAddr_t addr_;
//  Word_t port_;
//};
//============================================================================

#endif /* __GNUTMSGPARSER_H__ */

