//=============================================================================
// File: gnutpayload.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutpayload.h"
#include "gnut_util.h"

//=============================================================================
GnutPayload::
GnutPayload(void)
: bootstrap_res_(0) // this is required to ensure that the test in the d'tor
                    // works.
{ }
//=============================================================================
GnutPayload::
GnutPayload(const BootstrapRes& aRes)
: bootstrap_res_(new BootstrapRes(aRes))
{ }
//=============================================================================
GnutPayload::
GnutPayload(const PongRes& aRes)
: pong_res_(new PongRes(aRes))
{ }
//=============================================================================
GnutPayload::
~GnutPayload(void)
{
//    // TODO: AD - danger!!!  Ok?
//    delete bootstrap_res_;
//    delete pong_res_;

    GNUT_ASSERT(bootstrap_res_ == 0 || pong_res_ == 0);
    // Otherwise, memory leak
}
//=============================================================================
const BootstrapRes& 
GnutPayload::
getBootstrapRes(void) const
{
    GNUT_ASSERT(bootstrap_res_ != 0);
    return *bootstrap_res_;
}
//=============================================================================
const PongRes& 
GnutPayload::
getPongRes(void) const
{
    GNUT_ASSERT(pong_res_ != 0);
    return *pong_res_;
}
//=============================================================================
void
GnutPayload::
freeBootstrapRes(void)
{
    delete bootstrap_res_;
    bootstrap_res_ = 0;
}
//=============================================================================
void
GnutPayload::
freePongRes(void)
{
    delete pong_res_;
    pong_res_ = 0;
}
//=============================================================================
void
GnutPayload::
setBootstrapRes(const BootstrapRes& aRes)
{
    bootstrap_res_ = new BootstrapRes(aRes);
}
//=============================================================================
void
GnutPayload::
setPongRes(const PongRes& aRes)
{
    pong_res_ = new PongRes(aRes);
}
//=============================================================================

