//=============================================================================
// File: gnutpongmsg.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutpongmsg.h"
#include "gnutmsgparser.h"

//=============================================================================
GnutPongMsg::
GnutPongMsg(NodeAddr_t aInitialSender,
            DescriptorID_t aId, Byte_t aTtl, Byte_t aHops, Word_t aPort, 
            NodeAddr_t aAddr, const GnutCoord& aCoord, double aError)
: GnutBinaryMsgBC(aInitialSender, aId, GnutMsgParser::GNUT_PONG, aTtl, aHops,
                  aCoord, aError),
  res_(aPort, aAddr)
{ }
//=============================================================================
GnutPongMsg::
GnutPongMsg(const void* aMem)
: GnutBinaryMsgBC(aMem),
  res_(0, 0)
{ 
    const char* ptr = reinterpret_cast<const char*>(aMem);
    ptr += GnutBinaryMsgBC::getSize();
    memcpy(&res_, ptr, sizeof(res_));
}
//=============================================================================
GnutPongMsg::
~GnutPongMsg(void)
{ }
//=============================================================================
void 
GnutPongMsg::
writeToPacket(void* aMem) const
{ 
    GnutBinaryMsgBC::writeToPacket(aMem);

    char* ptr = reinterpret_cast<char*>(aMem);
    ptr += GnutBinaryMsgBC::getSize();
    memcpy(ptr, &res_, sizeof(res_));
}
//=============================================================================
size_t
GnutPongMsg::
getSize(void) const
{
    return GnutBinaryMsgBC::getSize() + sizeof(res_);
}
//=============================================================================

