//=============================================================================
// File: gnutpongmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a pong message.
//=============================================================================

#ifndef __GNUTPONGMSG_H__
#define __GNUTPONGMSG_H__

#include "gnutbinarymsgbc.h"
#include "gnut_types.h"

//=============================================================================
struct PongRes
{
    Word_t      port_;
    NodeAddr_t  addr_;

    PongRes(Word_t aPort, NodeAddr_t aAddr)
    : port_(aPort), addr_(aAddr)
    { }

    PongRes& operator=(const PongRes& aRes)
    {
        this->port_ = aRes.port_;
        this->addr_ = aRes.addr_;
        return *this;
    }
};
//=============================================================================
class GnutPongMsg : public GnutBinaryMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutPongMsg(NodeAddr_t aInitialSender,
                DescriptorID_t aId, Byte_t aTtl, Byte_t aHops, Word_t aPort, 
                NodeAddr_t aAddr, const GnutCoord& aCoord, double aError);

    // Build structure from packet.
    GnutPongMsg(const void* aMem);

    virtual ~GnutPongMsg(void);


    // = IGnutMsg

    virtual void writeToPacket(void* aMem) const;
    
    virtual size_t getSize(void) const;

    
    // = ACCESS

    const PongRes& getResult(void) const { return res_; }

private:
    // = DATA

    // TODO: AD is this public data ok?
    PongRes     res_; 


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutPongMsg(const GnutPongMsg&);
    GnutPongMsg& operator=(const GnutPongMsg&);
};
//=============================================================================
#endif /* __GNUTPONGMSG_H__ */

