//=============================================================================
// File: gnutqueryhitmsg.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutqueryhitmsg.h"
#include "gnutmsgparser.h"

//=============================================================================
GnutQueryHitMsg::
GnutQueryHitMsg(NodeAddr_t aInitialSender, DescriptorID_t aId, Byte_t aTtl, 
                Byte_t aHops, double aTimeQuerySent, const GnutCoord& aCoord, 
                double aError)
: GnutBinaryMsgBC(aInitialSender, aId, GnutMsgParser::GNUT_QUERYHIT, aTtl, 
                  aHops, aCoord, aError),
  mTimeQuerySent(aTimeQuerySent)
{ }
//=============================================================================
GnutQueryHitMsg::
GnutQueryHitMsg(const void* aMem)
: GnutBinaryMsgBC(aMem)
{ 
    const char* ptr = reinterpret_cast<const char*>(aMem);
    ptr += GnutBinaryMsgBC::getSize();
    memcpy(&mTimeQuerySent, ptr, sizeof(mTimeQuerySent));
}
//=============================================================================
GnutQueryHitMsg::
~GnutQueryHitMsg(void)
{ }
//=============================================================================
void 
GnutQueryHitMsg::
writeToPacket(void* aMem) const
{ 
    GnutBinaryMsgBC::writeToPacket(aMem);

    char* ptr = reinterpret_cast<char*>(aMem);
    ptr += GnutBinaryMsgBC::getSize();
    memcpy(ptr, &mTimeQuerySent, sizeof(mTimeQuerySent));
}
//=============================================================================
size_t
GnutQueryHitMsg::
getSize(void) const
{
    return GnutBinaryMsgBC::getSize() + sizeof(mTimeQuerySent);
}
//=============================================================================

