//=============================================================================
// File: gnutqueryhitmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a queryhit message.
//=============================================================================

#ifndef __GNUTQUERYHITMSG_H__
#define __GNUTQUERYHITMSG_H__

#include "gnutbinarymsgbc.h"
#include "gnut_types.h"

class GnutQueryHitMsg : public GnutBinaryMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutQueryHitMsg(NodeAddr_t aInitialSender,
                    DescriptorID_t aId, Byte_t aTtl, Byte_t aHops, 
                    double aTimeQuerySent, const GnutCoord& aCoord,
                    double aError);

    // Build structure from packet.
    GnutQueryHitMsg(const void* aMem);

    virtual ~GnutQueryHitMsg(void);

    // = ACTION

    void writeToPacket(void* aMem) const;

    // = ACCESS

    double getTimeQuerySent(void) const { return mTimeQuerySent; }
    size_t getSize(void) const;


private:
    // = DATA

    double mTimeQuerySent;


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutQueryHitMsg(const GnutQueryHitMsg&);
    GnutQueryHitMsg& operator=(const GnutQueryHitMsg&);
};
//=============================================================================
#endif /* __GNUTQUERYHITMSG_H__ */

