//=============================================================================
// File: gnutqueryrecord.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: encapsulates the information about the life of a query, eg.
//              how many nodes it has reached at a given time, when the query
//              hits were received, etc.
//=============================================================================

#ifndef __GNUTQUERYRECORD_H__
#define __GNUTQUERYRECORD_H__

#include <vector>
#include <set>
#include <cstdio>
#include "gnut_types.h"

class GnutQueryRecord
{
public:
    // = FOUNDATION

    GnutQueryRecord(void);
    GnutQueryRecord(double aTimeSent);
    virtual ~GnutQueryRecord(void);
    GnutQueryRecord(const GnutQueryRecord& aRecord);
    GnutQueryRecord& operator=(const GnutQueryRecord& aRecord);


    // = TYPES
public:
    typedef std::vector<double>  TimeVector;


    // = ACTION

    // Recording of new events
    void newNodeTime(NodeAddr_t aNode, double aTime);
    void newHitTime(double aTime);


    // = ACCESS

    const TimeVector& getNodeTimes(void) const { return mNodeTimes; }

    const TimeVector& getHitTimes(void) const { return mHitTimes; } 

    double getTimeSent(void) const { return mTimeSent; } 


private:
    // = TYPES

    typedef std::set<NodeAddr_t> NodeSet;


    // = DATA

    double              mTimeSent;
    // Time a query was initiated

    TimeVector          mNodeTimes;
    // Times a query reaches each Gnutella node. No duplicate records
    // for a query hitting the same node twice.

    NodeSet             mNodes;
    // Nodes this query has visited. Used to avoid duplicates in mNodeTimes

    TimeVector          mHitTimes;
    // Times query hits are recv'd at the originating node.
};
//=============================================================================
#endif /* __GNUTQUERYRECORD_H__ */

