// File: leaf.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __LEAF_H__
#define __LEAF_H__

#include "gnut_types.h"
#include "gnutellaapp.h"

class GnutHierApp;
class GnutCoord;

//=============================================================================
/* Leaf Gnutella Application */
class Leaf: public GnutellaApp 
{
public:
    // = FOUNDATION

    Leaf(NodeAddr_t aAddr, const char* const aParent, int aUsesVivaldi);
    virtual ~Leaf(void);


    // = ACTION

    virtual void bootstrap();
    virtual bool avail(EPeerType aType) const;
    virtual void disconnect(NodeAddr_t aPeer);

    int command(int argc, const char*const* argv);

private:
    int connectUpeer(NodeAddr_t aAddr);


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    Leaf(const Leaf&);
    Leaf& operator=(const Leaf&);
};
//=============================================================================

#endif /* __LEAF_H__ */

