// File: leafagent.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __LEAFAGENT_H__
#define __LEAFAGENT_H__

#include "gnutellaagent.h"
#include "gnut_types.h"

//=============================================================================
/* GnutellaAgent for a Leaf peer*/
class LeafAgent: public GnutellaAgent 
{
public:
    // = FOUNDATION

    LeafAgent(GnutellaApp* aApp);
    LeafAgent(NodeAddr_t aNode);
    virtual ~LeafAgent(void);


    // = ACTION

    virtual int upcall_recv(Socket* , PacketData* , Handler* );
    virtual void gnutella_req(Socket* sock);
    virtual void gnutella_ok(Socket* );


private:
    // = FOUNDATION
    LeafAgent(const LeafAgent&);
    LeafAgent& operator=(const LeafAgent&);
};

//=============================================================================

#endif /* __LEAFAGENT_H__ */

