// File: pdnsbootserver.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __PDNSBOOTSERVER_H__
#define __PDNSBOOTSERVER_H__

#include "smpbootserver.h"
#include "gnut_types.h"
#include "bootserverentry.h"
#include "pdnsservententry.h"

class GnutellaApp;

typedef std::map<NodeAddr_t, PDNSServentEntry> PDNSServentMap_t;

/* messages used to communicate among bootstrap servers */
struct PDNSBootMsg {
    int type_;
    NodeAddr_t peer_;
};

enum {
    ADD_PEER = 0,
    REM_PEER = 1,
    // ADD_AVAIL = 2,
    // REM_AVAIL = 3,
};

enum {BOOTSERVER_PORT = 6734};

//=============================================================================
/* PDNS bootstrap servers */
class PDNSBootServer: public SmpBootServer {
public:
    PDNSBootServer(NodeAddr_t);
    
    NodeAddr_t addr_;
    Port_t port_;
    BootServerMap_t bservers_;
    PDNSServentMap_t pservent_cache_;

    BootstrapRes* BootstrapRequest(NodeAddr_t node, GnutellaApp *, EPeerType peertype);
    void RemovePeer(NodeAddr_t node);
    void broadcast(int, NodeAddr_t peer);
    PDNSBootMsg *parse(int, unsigned char *);

    //  upcalls from Socket
    int upcall_recv(Socket *, PacketData *, Handler *);
    void upcall_connected(Socket *) {};
    void upcall_passconn(Socket *) {};
    void upcall_closing(Socket *) {};
    void upcall_send(Socket *) {};
protected:
    int command(int, const char*const*);
};

//=============================================================================

#endif /* __PDNSBOOTSERVER_H__ */

