// File: pingtime.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __PINGTIMER_H__
#define __PINGTIMER_H__

#include "timer-handler.h"
#include "ignuteventlistener.h"

class Event;

//=============================================================================
/* Periodic triggered timer to ping neighbours, maintained by IGnutellaApp*/
class PingTimer: public TimerHandler 
{
public:
    // = FOUNDATION

    PingTimer(const IGnutEventListener& aListener);
    virtual ~PingTimer(void);


    // = ACTION

    void resched(void);


    // = CONSTANTS

    static const unsigned int PING_INTERVAL;

protected:
    void expire(Event*);

private:
    // = DATA
  
    const IGnutEventListener&       mListener;


    // = FOUNDATION

    PingTimer(const PingTimer&);
    PingTimer& operator=(const PingTimer&);
};  

//=============================================================================

#endif /* __PINGTIMER_H__ */
