// File: smpbootserver.cc
// Original by Qi He
// Modified by Andre Dufour

#include "smpbootserver.h"
#include "gnut_types.h"
#include "gserventrec.h"
#include "gnutellaapp.h"
#include "gnut_util.h"
#include "gnutbootstrapresmsg.h"

//=============================================================================
SmpBootServer::SmpBootServer() 
{ }
//=============================================================================
SmpBootServer::~SmpBootServer() 
{ }
//=============================================================================
void SmpBootServer::RemovePeer(NodeAddr_t peer, GnutellaApp *app) 
{
    GServentMap_t::iterator fi = servent_cache_.find(peer);

    if(fi!=servent_cache_.end()) 
    {
      servent_cache_.erase(fi);
    }
}
//=============================================================================
/* called directly by a new servent for bootstrapping */
BootstrapRes*
SmpBootServer::BootstrapRequest(
    NodeAddr_t peer, GnutellaApp* app, EPeerType peertype) 
{
    int i = 0;
    int cnt = 0, asize = 0; 
    double thresh, prob;

    GnutUtil::gnutTrace("smp bootstrap request from %d. Cache has %u items\n", 
               peer, servent_cache_.size());

    for(GServentMap_t::const_iterator fi = servent_cache_.begin(); 
        fi != servent_cache_.end(); 
        ++fi) 
    {
        if(fi->second.app_->avail(peertype))
            cnt++;
    }

    asize = cnt > MAX_BOOTREPLY ? MAX_BOOTREPLY : cnt;
    if (cnt <= MAX_BOOTREPLY)
        thresh = 1;
    else
        thresh = (float)MAX_BOOTREPLY/(float)cnt;


    NodeAddr_t* addrs = new NodeAddr_t[asize];
    for(GServentMap_t::const_iterator fi = servent_cache_.begin(); 
        fi != servent_cache_.end(); 
        ++fi) 
    {
        // Always potentially available with Vivaldi
//        if(!fi->second.app_->avail(peertype))
//          continue;
        prob = (double)rand()/(double)RAND_MAX;
        if(prob <= thresh) 
        {      
            addrs[i] = fi->second.addr_;
            i++;
            if(i>=asize)
                break;
        }
    }

    if(peertype!=EPeerLeaf) 
    {
        GServentMap_t::const_iterator fi = servent_cache_.find(peer);
        if(fi==servent_cache_.end()) 
        {
            // TODO: AD
            GnutUtil::gnutTrace("Adding %d to cache\n", peer);

            GServentRec *newsrv;
            newsrv = new GServentRec(LISTEN_PORT, peer, 0, 0, app);
            servent_cache_.insert(GServentMap_t::value_type(peer, *newsrv));
        }
    }

    BootstrapRes* res = new BootstrapRes(i, addrs);
    delete[] addrs;
    return res;
}
//=============================================================================
static class SmpBootServerClass: public TclClass {
public:
  SmpBootServerClass(): TclClass("SocketApp/SmpBootServer") {}
  TclObject* create(int, const char*const* argv) {
    return (new SmpBootServer());
  }
}class_smpbootserver;
//=============================================================================


