// File: smpbootserver.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __SMPBOOTSERVER_H__
#define __SMPBOOTSERVER_H__

#include "gnut_types.h"

struct BootstrapRes;

//=============================================================================
/* bootstrapping server that uses random bootstrapping */
class SmpBootServer: public SocketApp 
{
public:
    // = FOUNDATION

    SmpBootServer();
    virtual ~SmpBootServer();

    
    // = ACTION

    virtual BootstrapRes* BootstrapRequest(NodeAddr_t, GnutellaApp *, EPeerType);
    void RemovePeer(NodeAddr_t, GnutellaApp *);

    
private:
    // = DATA

    GServentMap_t servent_cache_;


    // = FOUNDATION

    SmpBootServer(const SmpBootServer&);
    SmpBootServer& operator=(const SmpBootServer&);
};

//=============================================================================

#endif /* __SMPBOOTSERVER_H__ */

