// File: pingtimer.cc
// Original by Qi He
// Modified by Andre Dufour

#ifndef __WATCHDOG_H__
#define __WATCHDOG_H__

#include "timer-handler.h"
#include "ignuteventlistener.h"

//=============================================================================
class WatchDog: public TimerHandler 
{
public:
    // = FOUNDATION

    WatchDog(const IGnutEventListener& aListener);
    virtual ~WatchDog(void);


    // = ACTION

    void resched(void);

protected:
    void expire(Event*);


private:
    // = DATA

    const IGnutEventListener&   mListener;


    // = CONSTANTS

    static const unsigned int WATCH_INTERVAL;

    
    // = FOUNDATION

    WatchDog(const WatchDog&);
    WatchDog& operator=(const WatchDog&);
};
//=============================================================================

#endif /* __WATCHDOG_H__ */

