// File: activitycontroller.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __ACTIVITYCONTROLLER_H__
#define __ACTIVITYCONTROLLER_H__

#include "gnut_types.h"
#include "gnutellaapp.h"

//=============================================================================
/* dynamically controls peer behavior according to a system and class model */
class ActivityController: public TimerHandler{
  friend class GnutellaApp;
 public:
  ActivityController(PeerSys *, GnutellaApp *, int);
  
  PeerSys *sys_;
  GnutellaApp *app_;
  PeerState_t *state_; //pointer to the app_->state_
  virtual void expire(Event *); //next change of state_
  virtual void gen_query(); //generate a query based on cdffile_

  ClassSpec_t *clSpec_; //class spec of the peer
};

//=============================================================================

#endif /* __ACTIVITYCONTROLLER_H__ */

