// the base class that maintains statistics (calculated out of samples)
#ifndef __BASIC_STATS_H__
#define __BASIC_STATS_H__

#include "gnut_types.h"

class BasicStat {
public:
  BasicStat(NodeAddr_t addr) {
      cnt_=0; 
      tstamp_=0;
      avg_=0;
      std_=0;
      addr_ = addr;
      online_time_=0;
      last_online_=-1;
      cumtime_ = 0;
      prev_ = 0;
  };

  void increment() {
    if(tstamp_==0) 
      tstamp_ = NOW;
    else {
      double dtime = NOW - tstamp_;
      avg_ = (avg_ * (double)cnt_ +  dtime)/ (double)(cnt_+1);
      std_ = (pow((dtime - avg_), 2) + std_ * cnt_)/(double)(cnt_+1);    
      tstamp_ = NOW;
    }
    cnt_++;    
  };

  void increment(int value) {
    if(tstamp_==0) {
      tstamp_ = NOW;
      prev_ = value;
    } else {
      double dtime = NOW - tstamp_;
      avg_ = (avg_*cumtime_ + (double)prev_*dtime)/ (double)(cumtime_+dtime);
      cumtime_ += dtime;
      tstamp_ = NOW;
      prev_ = value;
    }
    cnt_++;
  }

  void increment2(int value) {
    avg_ = (avg_*(double)cnt_ + value)/(double)(cnt_+1);
    std_ = (pow((value-avg_), 2) + std_*(double)cnt_)/(double)(cnt_+1);
    cnt_++;
  }

  int total() {
    return cnt_;
  }

  void print(int i) {
    if(cnt_>1) {	
      double tmp = online_time_;
      if(last_online_!=-1) 
      	tmp += NOW - last_online_;

      //statistics 
      switch(i) {
      case 0:
  	printf("Unicast drop (%d)\t%d\t%f\t%f\n", addr_, cnt_, avg_, tmp);
	break;
	
      case 1:
  	printf("Broadcast drop (%d)\t%d\t%f\t%f\n", addr_, cnt_, avg_, tmp);
	break;
	
      case 2:
	printf("Degree (%d)\t%d\t%f\t%f\n", addr_, cnt_, avg_, tmp);
	break;

      case 3:
	printf("Recv rate (%d)\t%d\t%f\t%f\n", addr_, cnt_, avg_, tmp);
	break;
	
      default:
	break;
      }
      fflush(NULL);
    }
  }

  void online() {
    last_online_ = NOW;
  }

  void offline() {
    if (last_online_!=-1) {
  	online_time_ += NOW - last_online_;
	last_online_ = -1;
    }
    tstamp_ = 0;
  }

 private:
  int cnt_; //number of samples
  double tstamp_; //timestamp of last sample
  double avg_;  //average of the samples
  double std_;  //standard deviation of the samples
  double online_time_; //time since online, updated when going offline
  double last_online_; //last time instance switching to online state
  double cumtime_; //time since online, updated on every sample
  int prev_; //previous sample value
  NodeAddr_t addr_;  //address of the peer

};

#endif /* __BASIC_STATS_H__ */
