// File: bootserverentry.h
// Original by Qi He
// Modified by Andre Dufour
#ifndef __BOOTSERVERENTRY_H__
#define __BOOTSERVERENTRY_H__

#include "gnut_types.h"

/* bootstrap servers on other nodes that are known to this bootserver */
class BootServerEntry 
{
public:
    // = FOUNDATION

    BootServerEntry(NodeAddr_t aAddr, Socket* aSock);
    virtual ~BootServerEntry(void);
    
    BootServerEntry(const BootServerEntry&);
    BootServerEntry& operator=(const BootServerEntry&);

    // = DATA

    NodeAddr_t addr_; 
    Socket* sock_;
};

typedef std::map<NodeAddr_t, BootServerEntry> BootServerMap_t;

#endif /* __BOOTSERVERENTRY_H__ */

