//=============================================================================
// File: gnutbinarymsgbc.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutbinarymsgbc.h"
#include <string.h>
#include "gnut_types.h"

//=============================================================================
GnutBinaryMsgBC::
GnutBinaryMsgBC(DescriptorID_t aId, EGnutMSgType aType, Byte_t aTtl, 
                Byte_t aHops)
: hdr_(aId, aType, aTtl, aHops)
{ }
//=============================================================================
GnutBinaryMsgBC::
GnutBinaryMsgBC(const void* aMem)
{ 
    const char* ptr = reinterpret_cast<const char*>(aMem);

    memcpy(&hdr_.payload_desc_, ptr, sizeof(hdr_.payload_desc_));
    ptr += sizeof(hdr_.payload_desc_);

    memcpy(&hdr_.id_, ptr, sizeof(hdr_.id_));
    ptr += sizeof(hdr_.id_);

    memcpy(&hdr_.ttl_, ptr, sizeof(hdr_.ttl_));
    ptr += sizeof(hdr_.ttl_);

    memcpy(&hdr_.hops_, ptr, sizeof(hdr_.hops_));
    ptr += sizeof(hdr_.hops_);

    memcpy(&hdr_.length_, ptr, sizeof(hdr_.length_));
}
//=============================================================================
GnutBinaryMsgBC::
~GnutBinaryMsgBC(void)
{ }
//=============================================================================
void 
GnutBinaryMsgBC::
writeToPacket(void* aMem)
{ 
    char* ptr = reinterpret_cast<char*>(aMem);

    memcpy(ptr, &hdr_.payload_desc_, sizeof(hdr_.payload_desc_));
    ptr += sizeof(hdr_.payload_desc_);
    
    memcpy(ptr, &hdr_.id_, sizeof(hdr_.id_));
    ptr += sizeof(hdr_.id_);

    memcpy(ptr, &hdr_.ttl_, sizeof(hdr_.ttl_));
    ptr += sizeof(hdr_.ttl_);

    memcpy(ptr, &hdr_.hops_, sizeof(hdr_.hops_));
    ptr += sizeof(hdr_.hops_);

    memcpy(ptr, &hdr_.length_, sizeof(hdr_.length_));
}
//=============================================================================
size_t
GnutBinaryMsgBC::
getSize(void) const
{
    return sizeof(hdr_.id_) + sizeof(hdr_.payload_desc_) + sizeof(hdr_.ttl_) + 
           sizeof(hdr_.hops_) + sizeof(hdr_.length_);
}
//=============================================================================

