//=============================================================================
// File: gnutbinarymsgbc.h
// Author: Andre Dufour
//
// Class type: abstract base
// Description: superclass for all gnutella binary messages (i.e. those 
//              exchanged once a gnutella connection has been established
//              between peers).
//=============================================================================

#ifndef __GNUTBINARYMSGBC_H__
#define __GNUTBINARYMSGBC_H__

#include "ignutmsg.h"
#include "gnut_types.h"

//=============================================================================

// TODO: AD - don't inline member functions of this struct.
struct GnutDescHdr
{
    DescriptorID_t      id_;
    EGnutMsgType        payload_desc_;
    Byte_t              ttl_;
    Byte_t              hops_;
//    size_t              length_;

    // TODO: AD - do we need length_ ?
    GnutDescHdr(DescriptorID_t aId, EGnutMsgType aType, Byte_t aTtl, 
                Byte_t aHops)
    : payload_desc_(aType), ttl_(aTtl), hops_(aHops)
    { 
        id_ = new char[DESCRIPTOR_SIZE];
        memcpy(id_, aId, sizeof(id_));
    }

    ~GnutDescHdr(void)
    {
        delete[] id_;
    }

    GnutDescHdr& operator=(const GnutDescHdr& aHdr)
    {
        if (&aHdr != this)
        {
            delete[] id_;
            id_ = new char[DESCRIPTOR_SIZE];
            memcpy(this->id_, aHdr.id_, sizeof(this->id_));
            this->payload_desc_     = aHdr.payload_desc_;
            this->ttl_              = aHdr.ttl_;
            this->hops_             = aHdr.hops_;
    //        this->length            = aHdr.length_;
        }

        return *this;
    }
};
//=============================================================================
class GnutBinaryMsgBC : public IGnutMsg
{
protected:
    // = FOUNDATION

    // Build structure from user input
    GnutBinaryMsgBC(DescriptorID_t aId, EGnutMSgType aType, Byte_t aTtl, Byte_t aHops);

    // Build structure from packet.
    GnutBinaryMsgBC(const void* aMem);

    // Make class abstact
    virtual ~GnutBinaryMsgBC(void) = 0;


    // = IGnutMsg

    virtual void writeToPacket(void* aMem) const;
    

    // = ACCESS

    // Get length of the binarymsg header in packet.
    virtual size_t getSize(void) const;

    const GnutDescHdr& getHeader(void) const { return hdr_; }


private:
    // = DATA

    GnutDescHdr         hdr_;

    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutBinaryMsgBC(const GnutBinaryMsgBC&);

    GnutBinaryMsgBC& operator=(const GnutBinaryMsgBC&);

};
//=============================================================================
#endif /* __GNUTBINARYMSGBC_H__ */

