//=============================================================================
// File: gnutbootcacheupdatemsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a bootcacheupdate message.
//=============================================================================

#ifndef __GNUTBOOTCACHEUPDATEMSG_H__
#define __GNUTBOOTCACHEUPDATEMSG_H__

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

//=============================================================================
class GnutBootcacheUpdateMsg : public GnutBinaryMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input
    // Hops is always = 0 for this type of msg.
    GnutBootcacheUpdateMsg(DescriptorID_t aId, Byte_t aTtl);

    // Build structure from packet.
    GnutBootcacheUpdateMsg(const void* aMem);

    virtual ~GnutBootcacheUpdateMsg(void);

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutBootcacheUpdateMsg(const GnutBootcacheUpdateMsg&);
    GnutBootcacheUpdateMsg& operator=(const GnutBootcacheUpdateMsg&);
};
//=============================================================================
#endif /* __GNUTBOOTCACHEUPDATEMSG_H__ */

