//=============================================================================
// File: gnutbootstrapresmsg.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutbootstrapresmsg.h"

//=============================================================================
GnutBootstrapResMsg::
GnutBootstrapResMsg(int aCnt, const NodeAddr_t* aServents)
: GnutConnectMsgBC(GNUT_BOOTSTRAP_RES),
  res_(aCnt, aServents)
{ }
//=============================================================================
GnutBootstrapResMsg::
GnutBootstrapResMsg(const void* aMem)
: GnutConnectMsgBC(aMem)
{ 
    const char* ptr = reinterpret_cast<const char*>(aMem);

    ptr += GnutConnectMsgBC::getSize();

    memcpy(&res_.cnt_, ptr, sizeof(res_.cnt_));
    ptr += sizeof(res_.cnt_);

    res_.servents_ = new NodeAddr_t[res_.cnt_];
    memcpy(&res_.servents_, ptr, sizeof(res_.servents_));
}
//=============================================================================
GnutBootstrapResMsg::
~GnutBootstrapResMsg(void)
{ }
//=============================================================================
void 
GnutBootstrapResMsg::
writeToPacket(void* aMem)
{ 
    GnutConnectMsgBC::writeToPacket(aMem);

    char* ptr = reinterpret_cast<char*>(aMem);

    ptr += GnutConnectMsgBC::getSize();

    memcpy(ptr, &res_.cnt_, sizeof(res_.cnt_));
    ptr += sizeof(res_.cnt_);

    memcpy(ptr, &res_.servents_, sizeof(res_.servents_));
}
//=============================================================================
size_t
GnutBootstrapResMsg::
getSize(void) const
{
    return GnutConnectMsgBC::getSize() + sizeof(res_.cnt_) 
           + sizeof(res_.servents_);
}
//=============================================================================

