//=============================================================================
// File: gnutbootstrapresmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a bootstrapres message.
//=============================================================================

#ifndef __GNUTBOOTSTRAPRESMSG_H__
#define __GNUTBOOTSTRAPRESMSG_H__

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

//=============================================================================
struct BootstrapRes
{
    int         cnt_;
    NodeAddr_t* servents_;

    BootstrapRes(int cnt, NodeAddr_t* servents)
    : cnt_(cnt)
    { 
        servents_ = new NodeAddr_t[cnt];
        memcpy(servents_, servents, sizeof(servents_);
    }

    ~BootstrapRes(void)
    { 
        delete[] servents_; 
    }

    BootstrapRes& operator=(const BootstrapRes& aRes)
    {
        if (&aRes != this)
        {
            // TODO: AD - ensure that this is new and not malloc!!!
            delete[] servents_;
            
            this->cnt_ = aRes.cnt_;
            servents_ = new NodeAddr_t[this->cnt_];
            memcpy(servents_, aRes.servents_, sizeof(servents_);
        }

        return *this;
    }
};
//=============================================================================
class GnutBootstrapResMsg : public GnutConnectMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutBootstrapResMsg(DescriptorID_t aId, Byte_t aTtl, Byte_t aHops, int aCnt, 
                        const NodeAddr_t* aServents);

    // Build structure from packet.
    GnutBootstrapResMsg(const void* aMem);

    virtual ~GnutBootstrapResMsg(void);


    // = IGnutMsg

    virtual void writeToPacket(void* aMem);

    virtual size_t getSize(void) const;


    // = ACCESS

    const BootstrapRes& getResult(void) const { return res_; }


private:
    // = DATA

    // TODO: AD is this public data ok?
    BootstrapRes            res_;


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutBootstrapResMsg(const GnutBootstrapResMsg&);
    GnutBootstrapResMsg& operator=(const GnutBootstrapResMsg&);
};
//=============================================================================
#endif /* __GNUTBOOTSTRAPRESMSG_H__ */

