//=============================================================================
// File: gnutconnectmsgbc.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

//=============================================================================
GnutConnectMsgBC::
GnutConnectMsgBC(EGnutMsgType aType)
: msg_types_(aType)
{ }
//=============================================================================
GnutConnectMsgBC::
GnutConnectMsgBC(const void* aMem)
: msg_type_(*(reinterpret_cast<const EGnutMsgType*>(aMem)))
{ }
//=============================================================================
GnutConnectMsgBC::
~GnutConnectMsgBC(void)
{ }
//=============================================================================
void 
GnutConnectMsgBC::
writeToPacket(void* aMem)
{ 
    EGnutMsgType* ptr = reinterpret_cast<EGnutMsgType*>(aMem);
    *ptr = msg_type_;
}
//=============================================================================
size_t
GnutConnectMsgBC::
getSize(void) const
{
    return sizeof(msg_type_);
}
//=============================================================================

