//=============================================================================
// File: gnutconnectmsgbc.h
// Author: Andre Dufour
//
// Class type: abstract base
// Description: superclass for all gnutella connect messages (i.e. those 
//              exchanged while trying to establish a gnutella connection 
//              between peers).
//=============================================================================

#ifndef __GNUTCONNECTMSGBC_H__
#define __GNUTCONNECTMSGBC_H__

#include "ignutmsg.h"
#include "gnut_types.h"

//=============================================================================
class GnutConnectMsgBC : public IGnutMsg
{
protected:
    // = FOUNDATION

    // Build structure from user input
    GnutConnectMsgBC(EGnutMsgType aType)

    // Build structure from packet.
    GnutConnectMsgBC(const void* aMem);

    // Make class abstact
    virtual ~GnutConnectMsgBC(void) = 0;


    // = IGnutMsg

    virtual void writeToPacket(void* aMem) const;
    

    // = ACCESS

    // Get length of the connectmsg header in packet.
    virtual size_t getSize(void) const;


private:
    // = DATA

    EGnutMsgType        msg_type_;


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutConnectMsgBC(const GnutConnectMsgBC&);

    GnutConnectMsgBC& operator=(const GnutConnectMsgBC&);

};
//=============================================================================
#endif /* __GNUTCONNECTMSGBC_H__ */

