// File: gnutellaapp.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __GNUTELLAAPP_H__
#define __GNUTELLAAPP_H__

#include "gnut_types.h"
#include "peerapp.h"
#include "basicstat.h"
#include "ignutellaapp.h"
#include "pingtimer.h"
#include "watchdog.h"
#include "basicstat.h"
#include "gnuteventlistener.h"

class PingTimer;

//=============================================================================
/* GnutellaApp: Gnutella application, such as LimeWire, Gnucleus */
class GnutellaApp: public PeerApp, public IGnutellaApp
{
public:
    // = FOUNDATION

    GnutellaApp(NodeAddr_t addr);
    virtual ~GnutellaApp();


    // = ACTION    

    /*user command interface */
    virtual void join();
    virtual void leave();
    virtual void stop();  //"stop" is forced "leave" but its current 
                          //implementation is identical to "leave"
    virtual void search(char* criteria); 
    virtual void share();
    virtual void disconnect(NodeAddr_t node);
    virtual void update_bootcache();
    void setState(PeerState_t newstate);
    virtual int cleanup(); // to be called before the object is destroyed.
                           // Can perform stuff that uses the TCL side of
                           // the split object. That's not possible in d'tor.

    /* upcalls provided to GnutellaAgent*/
    virtual void ConnectSucceeded(NodeAddr_t peer);
    void ConnectionRejected(NodeAddr_t peer);
    void ConnectionFailed(NodeAddr_t peer);
    void ConnectionTimeout(NodeAddr_t peer);
    void ConnectionClosed(NodeAddr_t peer);
    virtual int  ConnectionRequest(NodeAddr_t peer, Socket* socket);
    virtual int  UltraConnRequest(NodeAddr_t peer, Socket* socket);
    virtual int  LeafConnRequest(NodeAddr_t peer, Socket* socket);
    virtual void PingRequest(NodeAddr_t peer, int ttl, char* id);
    virtual void PongReply(NodeAddr_t peer, int ttl, char* payload);
    virtual void QueryRequest(NodeAddr_t peer, int ttl, char* payload, 
                              char* id);
    virtual void QueryHitReply(NodeAddr_t peer, int ttl, char* payload);
    virtual void BootstrapRequest(NodeAddr_t peer);
    virtual void BootstrapResult(int, NodeAddr_t* );
    virtual void BootcacheUpdate(NodeAddr_t peer);

    // Watchdog callback
    void watchdogExpired(void);

    // Ping timer callback
    void pingExpired(void);

    /* internal operations related to peer connections*/
    virtual void bootstrap();
    virtual void maintenance();
    virtual void ping();
    virtual bool avail(EPeerType aType) const;
    virtual void smp_bootstrap();
    void setBootServer(FILE* );
    int find_servent(NodeAddr_t);
    void remove_servent(NodeAddr_t);

protected:
    virtual void connect(bool aTryBootserver, 
                         bool* aTimerReload = 0 // indicates whether the watchdog
                                                // should be rescheduled
                        );
public:

    virtual int command(int argc, const char*const* argv);

    // = DATA
// TODO: AD: ping_interval_, watch_interval_ and max_deg_ should be made
//           static, but the TCL binding is trickier. Later...

    // int ping_interval_;
    // int watch_interval_;
    int isBootserver_;
    int max_deg_;
    PingTimer ping_timer_; 
    WatchDog watchDog_;
    GnutellaAgent* gagent_;
    ServentMap_t servent_cache_;
    BasicStat degree_;
    BServerList_t bserver_list_;
    int smpBoot_;
    SmpBootServer* bootSrv_;
private:
    const GnutEventListener<GnutellaApp> watchdogListener_;
    const GnutEventListener<GnutellaApp> pingListener_;

private:
    // = FOUNDATION

    GnutellaApp(const GnutellaApp&);
    GnutellaApp& operator=(const GnutellaApp&);
};


//=============================================================================

#endif /* __GNUTELLAAPP_H__ */

