//=============================================================================
// File: gnuthierapp.cc
// Author: Andre Dufour
//=============================================================================

#include "gnuthierapp.h"
#include "gnut_types.h"
#include "leaf.h"
#include "ultrapeer.h"
#include "gnut_util.h"

//=============================================================================
GnutHierApp::
GnutHierApp(NodeAddr_t aAddr, EGnutAppType aInitAppType)
: mAddr(aAddr),
  mActiveApp(0)
{
    setActiveApp(aInitAppType);
}
//=============================================================================
GnutHierApp::
~GnutHierApp(void)
{
    delete mActiveApp;
    mActiveApp = 0;
}
//=============================================================================
void 
GnutHierApp::
setActiveApp(EGnutAppType aApp)
{
    switch (aApp)
    {
    case EGnutAppLeaf:
        break;

    case EGnutAppUltrapeer:
        break;

    default:
        GNUT_ASSERT(0);
        break;
    }

    mActiveApp = mApps[aApp];
}
//=============================================================================
void
GnutHierApp::
join()
{ }
//=============================================================================
void
GnutHierApp::
leave()
{ }
//=============================================================================
void
GnutHierApp::
search(char* criteria)
{ }
//=============================================================================
void
GnutHierApp::
share()
{ }
//=============================================================================
void
GnutHierApp::
setState(PeerState_t newstate)
{ }
//=============================================================================
void
GnutHierApp::
setFreeloader(int freeloader)
{ }
//=============================================================================
void
GnutHierApp::
bootstrap()
{ }
//=============================================================================
void
GnutHierApp::
maintenance()
{ }
//=============================================================================
void
GnutHierApp::
connect()
{ }
//=============================================================================
void
GnutHierApp::
stop()
{ }
//=============================================================================
void
GnutHierApp::
disconnect(NodeAddr_t node)
{ }
//=============================================================================
void
GnutHierApp::
update_bootcache()
{ }
//=============================================================================
void
GnutHierApp::
ConnectSucceeded(NodeAddr_t peer)
{ }
//=============================================================================
void
GnutHierApp::
ConnectionRejected(NodeAddr_t peer)
{ }
//=============================================================================
void
GnutHierApp::
ConnectionFailed(NodeAddr_t peer)
{ }
//=============================================================================
void
GnutHierApp::
ConnectionTimeout(NodeAddr_t peer)
{ }
//=============================================================================
void
GnutHierApp::
ConnectionClosed(NodeAddr_t peer)
{ }
//=============================================================================
int
GnutHierApp::
 ConnectionRequest(NodeAddr_t peer, Socket *socket)
{   return 0;}
//=============================================================================
int
GnutHierApp::
 UltraConnRequest(NodeAddr_t peer, Socket *socket)
{   return 0;}
//=============================================================================
int
GnutHierApp::
 LeafConnRequest(NodeAddr_t peer, Socket *socket)
{ 
    return 0;
}
//=============================================================================
void
GnutHierApp::
PingRequest(NodeAddr_t peer, int ttl, char *id)
{ }
//=============================================================================
void
GnutHierApp::
PongReply(NodeAddr_t peer, int ttl, char* payload)
{ }
//=============================================================================
void
GnutHierApp::
QueryRequest(NodeAddr_t peer, int ttl, char* payload, 
             char *id)
{ }
//=============================================================================
void
GnutHierApp::
QueryHitReply(NodeAddr_t peer, int ttl, char* payload)
{ }
//=============================================================================
void
GnutHierApp::
BootstrapRequest(NodeAddr_t peer)
{ }
//=============================================================================
void
GnutHierApp::
BootstrapResult(int, NodeAddr_t *)
{ }
//=============================================================================
void
GnutHierApp::
BootcacheUpdate(NodeAddr_t peer)
{ }
//=============================================================================
void
GnutHierApp::
ping()
{ }
//=============================================================================
int
GnutHierApp::
avail(int)
{ 
    return 0;
}
//=============================================================================
void
GnutHierApp::
smp_bootstrap()
{ }
//=============================================================================
void
GnutHierApp::
setBootServer(FILE *)
{ }
//=============================================================================
int
GnutHierApp::
find_servent(NodeAddr_t)
{ 
    return 0;
}
//=============================================================================
void
GnutHierApp::
remove_servent(NodeAddr_t)
{ }
//=============================================================================
int
GnutHierApp::
command(int argc, const char*const*)
{ 
    return 0;
}
//=============================================================================


