//=============================================================================
// File: gnuthierapp.cc
// Author: Andre Dufour
//=============================================================================

#include "gnuthierapp.h"
#include "gnut_types.h"
#include "leaf.h"
#include "ultrapeer.h"
#include "gnut_util.h"
#include "tclcl.h"

//=============================================================================
unsigned long GnutHierApp::mUltrapeerMinTime = 0;
const char* GnutHierApp::APP_NAMES[EGnutAppLast] = 
                           { "LeafActive", "UltrapeerActive", "LegacyActive" };
//=============================================================================
//GnutHierApp::
//GnutHierApp(NodeAddr_t aAddr, EGnutAppType aInitAppType, 
//            bool aUltrapeerCapable)
//: mAddr(aAddr),
//  mActiveApp(0),
//  mUltrapeerCapable(aUltrapeerCapable)
//{
//    GNUT_ASSERT(!((aInitAppType == EGnutAppUltrapeer) && 
//                  (aUltrapeerCapable == false)));
//    setActiveApp(aInitAppType);
//}
//=============================================================================
GnutHierApp::
GnutHierApp(NodeAddr_t aAddr)
: mAddr(aAddr),
  mActiveApp(0),
  mUltrapeerCapable(false),
  mRole(EGnutAppLast)
{
    // TODO: AD - test ultrapeer capability!


    // TODO: AD - wish there was a more elegant way to do this.
    mAppActiveAction[EGnutAppLeaf] = &GnutHierApp::leafActive;
    mAppActiveAction[EGnutAppUltrapeer] = &GnutHierApp::ultrapeerActive;
    mAppActiveAction[EGnutAppLegacy] = &GnutHierApp::legacyActive;
}
//=============================================================================
// TODO: AD remove this one.
//GnutHierApp::
//GnutHierApp(NodeAddr_t aAddr)
//: mAddr(aAddr),
//  mActiveApp(0),
//  mUltrapeerCapable(false)
//{
//printf("Constr called\n\n\n");
////    setActiveApp(EGnutAppLegacy);
//}
//=============================================================================
GnutHierApp::
~GnutHierApp(void)
{
    // TODO: AD perform other cleanup?
    printf("GnutHierApp::dtor called\n");
    delete mActiveApp;
    mActiveApp = 0;
}
//=============================================================================
int
GnutHierApp::
command(int argc, const char*const* argv)
{ 
    // TODO: AD change to strncmp
    if (strcmp(argv[1], "linkActiveApp") == 0)
    {
        if (argc == 4)
        {
            for (unsigned int iter = 0; iter < EGnutAppLast; iter++)
            {
                if (strcmp(argv[2], APP_NAMES[iter]) == 0)
                {
                    return (this->*mAppActiveAction[iter])(argv[3]);
                }
            }
        }
        return TCL_ERROR;
    }
    else if (strcmp(argv[1], "debug_status") == 0)
    {
        mActiveApp->debug_status();
    }

    GNUT_ASSERT(mActiveApp);
    mActiveApp->command(argc, argv);

    return TCL_OK;
}
//=============================================================================
// Static
void 
GnutHierApp::
setMinUltrapeerTime(unsigned long aSeconds)
{
    GnutHierApp::mUltrapeerMinTime = aSeconds;
}
//=============================================================================
int
GnutHierApp::
leafActive(const char* const aApp)
{
    // TODO: AD do appropriate cleanup
    delete mActiveApp; // TODO: AD do the delete? What about TCL side?

    mRole = EGnutAppLeaf;
    mActiveApp = reinterpret_cast<Leaf*>(TclObject::lookup(aApp));
   
    return TCL_OK;
}
//=============================================================================
int
GnutHierApp::
ultrapeerActive(const char* const aApp)
{
    // TODO: AD do appropriate cleanup
    delete mActiveApp; // TODO: AD do the delete? What about TCL side?

    mRole = EGnutAppUltrapeer;
    mActiveApp = reinterpret_cast<Ultrapeer*>(TclObject::lookup(aApp));
    return TCL_OK;
}
//=============================================================================
int
GnutHierApp::
legacyActive(const char* const aApp)
{
    // TODO: AD do appropriate cleanup
    delete mActiveApp; // TODO: AD do the delete? What about TCL side?

    mRole = EGnutAppLegacy;
    mActiveApp = reinterpret_cast<GnutellaApp*>(TclObject::lookup(aApp));
    return TCL_OK;
}
//=============================================================================
static class GnutHierAppClass: public TclClass {
public:
  GnutHierAppClass(): TclClass("GnutHierApp") {}
  TclObject* create(int argc, const char*const* argv) {
    return (new GnutHierApp(atoi(argv[4])));
  }
}class_gnuthierapp;
//=============================================================================

