//=============================================================================
// File: gnuthierapp.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: Encapuslates the functionality of leafs and ultrapeers as well
//              as the rules governing leaf/ultrapeer promotions and demotions.
//              This is done to more closely approximate the dynamic behaviour 
//              of the hierarchical Gnutella 0.6 network.
//=============================================================================

#ifndef __GNUTHIERAPP_H__
#define __GNUTHIERAPP_H__

#include "gnut_types.h"
#include "ignutellaapp.h"

class GnutHierApp : public TclObject
{    

public:
    // = FOUNDATION

//    GnutHierApp(NodeAddr_t aAddr, EGnutAppType aInitAppType, bool aUltrapeerCapable);
    GnutHierApp(NodeAddr_t aAddr);
    virtual ~GnutHierApp(void);

 
    // TODO: AD check
    int command(int argc, const char*const*);

    static void setMinUltrapeerTime(unsigned long aSeconds);

private:
    // = ACTION

    int leafActive(const char* const aApp);
    int ultrapeerActive(const char* const aApp);
    int legacyActive(const char* const aApp);


    // = TYPES

    enum EGnutApp
    {
        EGnutAppFirst = 0,
        EGnutAppLeaf = EGnutAppFirst,
        EGnutAppUltrapeer,
        EGnutAppLegacy,

        EGnutAppLast
    };

    typedef int (GnutHierApp::*AppActiveAction)(const char* const aApp);
    // Action functions to be called when an the active application type changes.
    
 
    // = DATA

    NodeAddr_t              mAddr;
    IGnutellaApp*           mActiveApp;
    const bool              mUltrapeerCapable;
    EGnutApp                mRole;
    AppActiveAction         mAppActiveAction[EGnutAppLast];
    // Coupled with APP_NAMES. 
    // TODO: AD Find way to improve this.

    static unsigned long    mUltrapeerMinTime;
    // The minimum number of seconds a peer must be online before being
    // eligible for promotion to ultrapeer status.


    // = CONSTANTS

    static const char*      APP_NAMES[EGnutAppLast];


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutHierApp(const GnutHierApp&);

    GnutHierApp& operator=(const GnutHierApp&);
};
//=============================================================================
#endif /* __GNUTHIERAPP_H__ */

