//=============================================================================
// File: gnutint128.cc
// Author: Andre Dufour
//
// WARNING: this is not protable to platforms where "unsigned int" is not
//          a 32-bit type!
//=============================================================================

#include "gnutint128.h"
#include <limits.h>
#include <string.h>

//=============================================================================
GnutInt128::
GnutInt128(void)
{
    memset(mValue, 0, sizeof(mValue));
}
//=============================================================================
GnutInt128::
GnutInt128(unsigned int aInitValue)
{
    memset(mValue, 0, sizeof(mValue));
    mValue[3] = aInitValue;
}
//=============================================================================
GnutInt128::
~GnutInt128(void)
{ }
//=============================================================================
const GnutInt128& 
GnutInt128::
operator++(void)
{
    if (++mValue[3] == UINT_MAX)
    {
        mValue[3] = 0;
        
        if (++mValue[2] == UINT_MAX)
        {
            mValue[2] = 0;

            if (++mValue[1] == UINT_MAX)
            {
                mValue[1] = 0;

                if (++mValue[0] == UINT_MAX)
                {
                    mValue[0] = 0;
                }
            }
        }
    }

    return *this;
}
//=============================================================================
inline bool 
GnutInt128::
operator==(const GnutInt128& aInt) const
{
    if (memcmp(aInt.mValue, this->mValue, sizeof(this->mValue)) != 0)
    {
        return false;
    }
    else
    {
        return true;
    }
}
//=============================================================================
bool 
GnutInt128::
operator!=(const GnutInt128& aInt) const
{
    return !(aInt == *this);
}
//=============================================================================
//void
//GnutInt128::
//writeToMem(char* aMem) const
//{
//    // TODO: AD - check size of aMem
//    // WARNING: not portable to platforms where sizeof(unsigned int) != 32 bits
//    GNUT_ASSERT(aMem != 0);
//
//    memcpy(aMem, mValue, sizeof(mValue));
//}
//=============================================================================
char*
operator=(DescriptorID_t aMem, const GnutInt128& aInt)
{
    GNUT_ASSERT(aMem != 0);
    // TODO: AD - check size of aMem
    // WARNING: not portable to platforms where sizeof(unsigned int) != 32 bits

    memcpy(aMem, aInt.mValue, sizeof(aInt.mValue));
    return aMem;
}
//=============================================================================

