//=============================================================================
// File: gnutint128.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: encapsulates a 128-bit (16-byte) integer. Minimal functionality
//              Just enough to suit our Gnutella simulator purposes.
// 
// WARNING: this is not protable to platforms where "unsigned int" is not
//          a 32-bit type!
//=============================================================================

#ifndef __GNUTINT128_H__
#define __GNUTINT128_H__

#include "gnut_types.h"

class GnutInt128
{
public:
    // = FOUNDATION

    GnutInt128(void);
    GnutInt128(unsigned int aInitValue);
    virtual ~GnutInt128(void);


    // = ACTION

    const GnutInt128& operator++(void);
    //void writeToMemory(char* aMem) const;
    friend char* operator=(DescriptorID_t aMem, const GnutInt128&);

    // = EQUALITY

    bool operator==(const GnutInt128& aInt) const;
    bool operator!=(const GnutInt128& aInt) const;


private:
    // = DATA

    unsigned int mValue[4]; // 4 32-bit integers. mValue[0] is MSB


    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutInt128(const GnutInt128&);

    GnutInt128& operator=(const GnutInt128&);

};
//=============================================================================
#endif /* __GNUTINT128_H__ */

