// File: gnutmsgparser.cc
// Original by Qi He
// Modified by Andre Dufour


#include "gnutmsgparser.h"
#include "gnut_types.h"
#include "gnut_util.h"
#include "ignutmsg.h"

//============================================================================
// Private
GnutMsgParser::
GnutMsgParser(void) 
{ }
//============================================================================
// Private
GnutMsgParser::
~GnutMsgParser(void)
{ }
//============================================================================
GnutMsgParser&
GnutMsgParser::
instance(void)
{
    // WARNING: not thread safe. That's ok for ns-2 though.
    static GnutMsgParser parser;

    return parser;
}
//============================================================================
/* Gnutella Message Parsing */
EGnutMsgType 
GnutMsgParser::
parse(const unsigned char* data, GnutDescHdr* header, GnutPayload* payload) const
{
    EGnutMsgType msg_type = *(reinterpret_cast<const EGnutMsgType*>(data));

    switch (msg_type)
    {
    default:
        // Bad!
        GNUT_ASSERT(0);
        break;

    case GNUT_PING:
        if (header != 0)
        {
            GnutPingMsg ping(data);
            *header = ping.getHeader();
        }
        break;

    case GNUT_QUERY:
        if (header != 0)
        {
            GnutQueryMsg query(data);
            *header = query.getHeader();
        }
        break;

    case GNUT_QUERYHIT:
        if (header != 0)
        {
            GnutQueryHitMsg hit(data)
            *header = query.getHeader();
        }
        break;

    case GNUT_PONG:
        {
            GnutPongMsg pong(data);
            if (header != 0)
            {
                *header            = pong.getHeader();
            }
            if (payload != 0)
            {
                payload->pong_res_ = pong.getResult();
            }
        }
        break;


    case GNUT_BOOTSTRAP_RES:
        if (payload != 0)
        {
            GnutBootstrapResMsg bsr(data);
            payload->bootstrap_res = bsr.getResult();
        }
        break;

    case GNUT_BOOTSTRAP:
    case GNUT_LEGACY_CONNECT:
    case GNUT_OK:
    case GNUT_REJ:
    case GNUT_ULTRA_CONNECT:
    case GNUT_LEAF_CONNECT:
    case GNUT_ULTRA_OK:
    case GNUT_BOOTCACHE_UPDATE:
        // No other information required.
        break;

    } // switch(msg_type)

    return msg_type;
}
//============================================================================
/* compose a PacketData with a Gnutella message as the payload         */
/* called with message type and length, as well as some optional parms */
PacketData* 
GnutMsgParser::newpacket(const IGnutMsg& aMsg) const
{
    PacketData* userdata = new PacketData(aMsg.getSize());

    aMsg.writeToPacket(userdata->data());

    return userdata;
}
//============================================================================
GnutInt128 // Don't return reference. Want it to be copied.
GnutMsgParser::
getNewMsgId(void)
{
    return ++mGuid;
}
//============================================================================

