//=============================================================================
// File: gnutpingmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a ping message.
//=============================================================================

#ifndef __GNUTPINGMSG_H__
#define __GNUTPINGMSG_H__

#include "gnutbinarymsgbc.h"

class GnutPingMsg : public GnutBinaryMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutPingMsg(DescriptorID_t aId, Byte_t aTtl, Byte_t aHops);

    // Build structure from packet.
    GnutPingMsg(const void* aMem);

    virtual ~GnutPingMsg(void);


private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutPingMsg(const GnutPingMsg&);
    GnutPingMsg& operator=(const GnutPingMsg&);
};
//=============================================================================
#endif /* __GNUTPINGMSG_H__ */

