//=============================================================================
// File: gnutpongmsg.cc
// Author: Andre Dufour
//=============================================================================

#include "gnutpongmsg.h"

//=============================================================================
GnutPongMsg::
GnutPongMsg(DescriptorID_t aId, Byte_t aTtl, Byte_t aHops, Word_t aPort, 
            NodeAddr_t aAddr)
: GnutBinaryMsgBC(aId, GNUT_PONG, aTtl, aHops),
  res_(aPort, aAddr)
{ }
//=============================================================================
GnutPongMsg::
GnutPongMsg(const void* aMem)
: GnutBinaryMsgBC(aMem)
{ 
    const char* ptr = reinterpret_cast<const char*>(aMem);

    ptr += GnutBinaryMsgBC::getSize();

    memcpy(&res_.port_, ptr, sizeof(res_.port_));
    ptr += sizeof(res_.port_);

    memcpy(&res_.addr_, ptr, sizeof(res_.addr_));
}
//=============================================================================
GnutPongMsg::
~GnutPongMsg(void)
{ }
//=============================================================================
void 
GnutPongMsg::
writeToPacket(void* aMem)
{ 
    GnutBinaryMsgBC::writeToPacket(aMem);

    char* ptr = reinterpret_cast<char*>(aMem);

    ptr += GnutBinaryMsgBC::getSize();

    memcpy(ptr, &res_.port_, sizeof(res_.port_));
    ptr += sizeof(res_.port_);

    memcpy(ptr, &res_.addr_, sizeof(res_.addr_));
}
//=============================================================================
size_t
GnutPongMsg::
getSize(void) const
{
    return GnutBinaryMsgBC::getSize() + sizeof(res_.port_) + sizeof(res_.addr_);
}
//=============================================================================

