//=============================================================================
// File: gnutquerymsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a query message.
//=============================================================================

#ifndef __GNUTQUERYMSG_H__
#define __GNUTQUERYMSG_H__

#include "gnutbinarymsgbc.h"
#include "gnut_types.h"

class GnutQueryMsg : public GnutBinaryMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutQueryMsg(DescriptorID_t aId, Byte_t aTtl, Byte_t aHops);

    // Build structure from packet.
    GnutQueryMsg(const void* aMem);

    virtual ~GnutQueryMsg(void);


private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutQueryMsg(const GnutQueryMsg&);
    GnutQueryMsg& operator=(const GnutQueryMsg&);
};
//=============================================================================
#endif /* __GNUTQUERYMSG_H__ */

