//=============================================================================
// File: gnutrejmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a rej message.
//=============================================================================

#ifndef __GNUTREJMSG_H__
#define __GNUTREJMSG_H__

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

//=============================================================================
class GnutRejMsg : public GnutConnectMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutRejMsg(DescriptorID_t aId, Byte_t aTtl, Byte_t aHops);

    // Build structure from packet.
    GnutRejMsg(const void* aMem);

    virtual ~GnutRejMsg(void);

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutRejMsg(const GnutRejMsg&);
    GnutRejMsg& operator=(const GnutRejMsg&);
};
//=============================================================================
#endif /* __GNUTREJMSG_H__ */

