//=============================================================================
// File: gnutultraconnmsg.h
// Author: Andre Dufour
//
// Class type: concrete
// Description: structure to contain the details of a ultraconn message.
//=============================================================================

#ifndef __GNUTULTRACONNMSG_H__
#define __GNUTULTRACONNMSG_H__

#include "gnutconnectmsgbc.h"
#include "gnut_types.h"

//=============================================================================
class GnutUltraConnMsg : public GnutConnectMsgBC
{
public:
    // = FOUNDATION

    // Build structure from user input.
    GnutUltraConnMsg(void);
    
    // Build structure from packet.
    GnutUltraConnMsg(const void* aMem);

    virtual ~GnutUltraConnMsg(void);

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    GnutUltraConnMsg(const GnutUltraConnMsg&);
    GnutUltraConnMsg& operator=(const GnutUltraConnMsg&);
};
//=============================================================================
#endif /* __GNUTULTRACONNMSG_H__ */

