//=============================================================================
// File: ignutellaapp.h
// Author: Andre Dufour
//
// Class type: interface
// Description: Gnutella application to be implemented by all gnutella
//              app-layer classes.
//=============================================================================

#ifndef __IGNUTELLAAPP_H__
#define __IGNUTELLAAPP_H__

#include "ipeerapp.h"
#include "gnut_types.h"

class IGnutellaApp : public virtual IPeerApp
{
    // = FOUNDATION

protected:
    IGnutellaApp(void);
public:
    virtual ~IGnutellaApp(void);

    // = ACTION

    // Stop is forced "leave" but its current implementation is 
    // identical to "leave"
    virtual void stop() = 0; 

    virtual void disconnect(NodeAddr_t node) = 0;
    virtual void update_bootcache() = 0;
    virtual void ConnectSucceeded(NodeAddr_t peer) = 0;
    virtual void ConnectionRejected(NodeAddr_t peer) = 0;
    virtual void ConnectionFailed(NodeAddr_t peer) = 0;
    virtual void ConnectionTimeout(NodeAddr_t peer) = 0;
    virtual void ConnectionClosed(NodeAddr_t peer) = 0;
    virtual int  ConnectionRequest(NodeAddr_t peer, Socket *socket) = 0;
    virtual int  UltraConnRequest(NodeAddr_t peer, Socket *socket) = 0;
    virtual int  LeafConnRequest(NodeAddr_t peer, Socket *socket) = 0;
    virtual void PingRequest(NodeAddr_t peer, int ttl, char *id) = 0;
    virtual void PongReply(NodeAddr_t peer, int ttl, char* payload) = 0;
    virtual void QueryRequest(NodeAddr_t peer, int ttl, char* payload, 
                              char *id) = 0;
    virtual void QueryHitReply(NodeAddr_t peer, int ttl, char* payload) = 0;
    virtual void BootstrapRequest(NodeAddr_t peer) = 0;
    virtual void BootstrapResult(int, NodeAddr_t *) = 0;
    virtual void BootcacheUpdate(NodeAddr_t peer) = 0;
    virtual void bootstrap() = 0;
    virtual void maintenance() = 0;
    virtual void ping() = 0;
// TODO: AD    virtual void connect(bool aTryBootserver) = 0;
    virtual bool avail(EPeerType aType) const = 0;
    virtual void smp_bootstrap() = 0;
    virtual void setBootServer(FILE *) = 0;
    virtual int find_servent(NodeAddr_t) = 0;
    virtual void remove_servent(NodeAddr_t) = 0;

    // TODO: AD check
    virtual int command(int argc, const char*const* argv) = 0;

private:

    // = FOUNDATION

    // Disable copy constructor and assignment operator
    IGnutellaApp(const IGnutellaApp&);

    IGnutellaApp& operator=(const IGnutellaApp&);

};
//=============================================================================
#endif /* __IGNUTELLAAPP_H__ */

