//=============================================================================
// File: ignutmsg.h
// Author: Andre Dufour
//
// Class type: interface
// Description: interface for all gnutella messages.
//=============================================================================

#ifndef __IGNUTMSG_H__
#define __IGNUTMSG_H__

class IGnutMsg
{
protected:
    // = FOUNDATION

    IGnutMsg(void);
    virtual ~IGnutMsg(void);

public:
    // = ACTION

    virtual void writeToPacket(char* aMem) const = 0;

    
    // = ACCESS

    // Get size of message in bytes
    virtual size_t getSize(void) const = 0;


private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    IGnutMsg(const IGnutMsg&);
    IGnutMsg& operator=(const IGnutMsg&);

};
//=============================================================================
#endif /* __IGNUTMSG_H__ */

