//=============================================================================
// File: filename
// Author: Andre Dufour
//
// Class type: interface
// Description: Generic peer-to-peer application
//=============================================================================

#ifndef __IPEERAPP_H__
#define __IPEERAPP_H__

#include "gnut_types.h"

class IPeerApp
{
protected:
    // = FOUNDATION

    IPeerApp(void);
    virtual ~IPeerApp(void);


public:
    // = ACTION

    // User command interface
    virtual void join() = 0;
    virtual void leave() = 0;
    virtual void search(char* criteria) = 0;
    virtual void share() = 0;
    virtual void setState(PeerState_t newstate) = 0;
    virtual void setFreeloader(int freeloader) = 0;

    // Internal operations related to peer connections
    virtual void bootstrap() = 0;
    virtual void maintenance() = 0;
    virtual void connect() = 0;

    // TODO: AD debug
    virtual void debug_status() = 0;

private:
    // = FOUNDATION

    // Disable copy constructor and assignment operator
    IPeerApp(const IPeerApp&);

    IPeerApp& operator=(const IPeerApp&);

};
//=============================================================================

#endif /* __IPEERAPP_H__ */

