// File: leaf.cc
// Original by Qi He
// Modified by Andre Dufour

#include "leaf.h"
#include "gnut_types.h"
#include "smpbootserver.h"
#include "gnutellaapp.h"
#include "gnutellaagent.h"

//=============================================================================
/* Leaf Application */
Leaf::
Leaf(NodeAddr_t aAddr) :
  GnutellaApp(aAddr)
{ 
    printf("Creating leaf %p for node %d\n", this, aAddr);
}
//=============================================================================
Leaf::
~Leaf(void)
{ 
    // TODO: AD
    printf("Destroying leaf %d\n", addr_);
}
//=============================================================================
void 
Leaf::
bootstrap() 
{
    if(smpBoot_) 
    {
        BootstrapRes_t *res;

        res = bootSrv_->BootstrapRequest(this->addr_, this, EPeerLeaf);
        if(res==NULL)
            return;

        BootstrapResult(res->cnt_, res->servents_);
        if(res->servents_)
            free(res->servents_);

        free(res);
    } 
    else 
    {
        GnutellaApp::bootstrap();
    }
}
//=============================================================================
bool 
Leaf::
avail(EPeerType) const
{
    return false;
}
//=============================================================================
void 
Leaf::
disconnect(NodeAddr_t addr) 
{
    gagent_->Disconnect(addr);
    if(addr==-1) 
        lpeers_.clear();
    else 
    {
        PeerMap_t::iterator pi = lpeers_.find(addr);
        if(pi!=lpeers_.end()) 
        {
            lpeers_.erase(pi);
        }
    }
    degree_.increment(lpeers_.size());
}
//=============================================================================
static class LeafClass: public TclClass 
{
public:
    LeafClass(): TclClass("PeerApp/GnutellaApp/Leaf") {}
    TclObject* create(int argc, const char*const* argv) 
    {
      return (new Leaf(atoi(argv[4])));
    }
} class_leaf;
//=============================================================================

