/*-------------------------------------------------------------------------*/
/* Priority Message Queues on Gnutella servents                            */
/* Author: Qi He <http://www.cc.gatech.edu/~qhe> 01Aug2003                 */
/* $Revision:$ $Name:$ $Date:$                                             */
/*-------------------------------------------------------------------------*/
#ifndef NSSOCKET_PRIO
#define NSSOCKET_PRIO

//#include "peer_agent.h"
#include "gnut_types.h"
#define NUM_PRIOLEVELS 6
#define RBUF_LIMIT 5000
#define PBUF_LIMIT 100
#include <list>

typedef struct {
  int read_;
  PacketData *data_;
} PrioPkt_t;

typedef std::list<PrioPkt_t> PrioPktQueue;

class QueSocket: public Socket {
 public:
  QueSocket();
  void recv();
  int upcall_recv(PacketData *);
  PrioPktQueue pktqueue_;
  int avail_len_;
  int avail_pkt_;
};

class PrioSocket : public Socket {

 public:
  PrioSocket();

  PrioPktQueue pktqueue_[NUM_PRIOLEVELS][INIT_TTL+1];
  int send(int, PacketData *);
  void upcall_send(); 
  int prio_drop(int, int);
  int avail_len_;
  int avail_pkt_;
  int insert(PacketData *);

};
#endif

