// File: peerapp.cc
// Original by Qi He
// Modified by Andre Dufour

#include "peerapp.h"
#include "gnut_types.h"
#include "activitycontroller.h"

//=============================================================================
/*** base class: PeerApp ***/
PeerApp::
PeerApp(NodeAddr_t addr) 
: addr_(addr),
  shared_Mb_((int)((float)rand()/(float)RAND_MAX * 500.0)),
  shared_files_((int)((float)rand()*20.0/(float)RAND_MAX)),
  speed_((int)((float)rand()/(float)RAND_MAX*1500.0)),
  isFreeloader_(FALSE),
  agent_(0),
  ac_(0),
  state_(PS_OUTSYS)
{
    bind("shared_Mb_", &shared_Mb_);
    bind("shared_files_", &shared_files_);
    bind("speed_", &speed_);
    bind("isFreeloader_", &isFreeloader_);

    srand((unsigned int)addr);
}
//=============================================================================
PeerApp::
~PeerApp()
{ 
    printf("Destroying peerapp %d\n", addr_);
    delete ac_;
    ac_ = 0;
}
//=============================================================================
void 
PeerApp::
join()
{ }
//=============================================================================
void 
PeerApp::
leave()
{ }
//=============================================================================
void 
PeerApp::
search(char*)
{ }
//=============================================================================
void 
PeerApp::
share()
{ }
//=============================================================================
void 
PeerApp::
setState(PeerState_t newstate) 
{
    state_ = newstate; 
}
//=============================================================================
void 
PeerApp::
bootstrap()
{ }
//=============================================================================
void 
PeerApp::
maintenance()
{ }
//=============================================================================
void 
PeerApp::
connect()
{ }
//=============================================================================
// Debug function to print out some summary info about the peer
void
PeerApp::
debug_status()
{
    printf("Peer %d has the following connections: ", addr_);
    for (PeerMap_t::const_iterator iter = lpeers_.begin();
         iter != lpeers_.end();
         iter++)
    {
        printf("%d, ", iter->first);
    }
    printf("\n");
    fflush(NULL);
}
//=============================================================================
static class PeerAppClass: public TclClass {
public:
  PeerAppClass(): TclClass("PeerApp") {}
  TclObject* create(int argc, const char*const* argv) {
    return (new PeerApp(atoi(argv[4])));
  }
}class_peerapp;
//=============================================================================

