// File: peerapp.h
// Original by Qi He
// Modified by Andre Dufour

#ifndef __PEERAPP_H__
#define __PEERAPP_H__

#include "gnut_types.h"
#include "peerentry.h"
#include "ipeerapp.h"

//=============================================================================
/* base class for a peer-to-peer application */
#ifdef GTNETS
class PeerApp: public Application {
#else
class PeerApp: public TclObject, public virtual IPeerApp {
#endif
public:
    // = FOUNDATION

    PeerApp(NodeAddr_t addr);
    virtual ~PeerApp();


    // = ACTION

    /*user command interface */
    virtual void join();
    virtual void leave();
    virtual void search(char* criteria);
    virtual void share();
    virtual void setState(PeerState_t newstate);
    void setFreeloader(int freeloader) {isFreeloader_ = freeloader ;} ;

    /* internal operations related to peer connections*/
    virtual void bootstrap();
    virtual void maintenance();
    virtual void connect();
    
    // TODO: AD comment out in release build.
    virtual void debug_status();


    // DATA

    NodeAddr_t addr_;
    int shared_Mb_;
    int shared_files_;
    int speed_;
    int isFreeloader_;

    PeerAgent* agent_;
    ActivityController* ac_; //activity controller
    PeerState_t state_; //OFFLINE or ACTIVE or IDLE
    PeerMap_t lpeers_; //list of peers

    /* upcalls provided to GnutellaAgent*/
    Upcall_Proto* upcalls[10];

private:
    // = FOUNDATION

    PeerApp(const PeerApp&);
    PeerApp& operator=(const PeerApp&);

};

//=============================================================================

#endif /* __PEERAPP_H__ */

