// File: peerentry.h
// Original by Qi He
// Modified by Andre Dufour
#ifndef __PEERENTRY_H__
#define __PEERENTRY_H__

#include "gnut_types.h"

//=============================================================================
/* List of connected peers maintained by GnutellaApp */
class PeerEntry {
 public:
  PeerEntry(NodeAddr_t peer, double tstamp, Byte_t leaf) {
    peer_ = peer; 
    lstamp_ = tstamp; 
    isLeaf_ = leaf;
  }

  NodeAddr_t peer_;
  double lstamp_;
  Byte_t isLeaf_;
};
//=============================================================================

#endif /* __PEERENTRY_H__ */

