/*-------------------------------------------------------------------------*/
/* SocketTcp: subclass of AdvwTcpAgent that implements the services        */
/* provided by real system TCP socket, e.g.,                               */
/*      limited sender buffer,                                             */
/*      spawning new connections on request,                               */
/*      real payload transfer.                                             */ 
/* Author: Qi He <http://www.cc.gatech.edu/~qhe> 01Aug2003                 */
/* $Revision:$ $Name:$ $Date:$                                             */
/*-------------------------------------------------------------------------*/
#ifndef __NS_SOCKTCP
#define __NS_SOCKTCP
#include "tcp-advw.h"
#include "nilist.h"

class NSSocket;
class QueSocket;
class PrioSocket;

class PktDataEntry: public slink {
 public:
  PktDataEntry(int, PacketData *);
  
  PacketData *pktdata_;
};

class SocketTcp: public AdvwTcpAgent {
  friend class NSSocket;
  friend class QueSocket;
  friend class PrioSocket;
public:
	SocketTcp();
	
	int snd_wnd_;
	int listen_only_;
	int max_conn_;
	Islist<PktDataEntry> rcv_buf_;
	Islist<PktDataEntry> snd_buf_;
	void insert(Islist<PktDataEntry>*, PktDataEntry *);
	void recv(Packet *, Handler *);
	virtual int r_send(int bytes);
	virtual int r_send(PacketData *);
	virtual int r_sendmsg(int nbytes, const char *flags);
	virtual int send_dummy(int nbytes);
	virtual int r_sendmsg(PacketData *p, const char *flags);
	void sendpacket(int seqno, int ackno, int pflags, int datalen, PacketData *data, int reason);

	virtual int r_advance_bytes(int nb);
	virtual int r_advance_pkt(PacketData *p);
	int sendmsg(PacketData *, int len);
	void listen(int max);
	void ack_syn(Packet *);
 protected:
	void recvBytes(int);
	void newack(Packet *);
	int foutput(int seqno, int reason = 0);
	int command(int argc, const char*const* argv);


};

#endif
